<?php
// Ultra Simple REDLINE Bot - Independent Version
require_once 'config.php';
require_once 'analytics.php';

// Get input
$input = file_get_contents('php://input');
$update = json_decode($input, true);

// Fast response
http_response_code(200);
echo "OK";

// Handle /start
if (isset($update['message']['text']) && $update['message']['text'] === '/start') {
    $chat_id = $update['message']['chat']['id'];
    $username = $update['message']['from']['username'] ?? 'Unknown';
    
    // Track user interaction
    trackUser($chat_id, $username, 'start');
    
    // Send admin notification for new user
    sendAdminNotification($chat_id, $username, 'new_user');
    
    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🚀 Start', 'callback_data' => 'start']]
        ]
    ]);
    
    $message = $MESSAGES['welcome'];
    
    // Try to send photo first
    if (file_exists('REDLINE.png')) {
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendPhoto";
        $data = [
            'chat_id' => $chat_id,
            'photo' => new CURLFile('REDLINE.png'),
            'caption' => $message,
            'reply_markup' => $keyboard
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
    } else {
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
        $data = [
            'chat_id' => $chat_id,
            'text' => $message,
            'reply_markup' => $keyboard
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
    }
}

// Handle photo/document messages (screenshots)
if (isset($update['message']['photo']) || isset($update['message']['document'])) {
    $chat_id = $update['message']['chat']['id'];
    $username = $update['message']['from']['username'] ?? 'Unknown';
    
    // Track user interaction
    trackUser($chat_id, $username, 'screenshot_uploaded');
    
    // Forward screenshot to admin
    forwardScreenshotToAdmin($update['message'], $chat_id, $username);
    
    // Send admin notification about screenshot
    sendAdminNotification($chat_id, $username, 'screenshot_received');
    
    $message = $MESSAGES['payment_processing'];
    
    $keyboard = json_encode([
        'inline_keyboard' => [
            [['text' => '🔙 Back to Main Menu', 'callback_data' => 'start']]
        ]
    ]);
    
    sendMessage($chat_id, $message, $keyboard);
}

// Handle all text messages
if (isset($update['message']['text'])) {
    $chat_id = $update['message']['chat']['id'];
    $username = $update['message']['from']['username'] ?? 'Unknown';
    $text = $update['message']['text'];
    
    // Debug: Check admin status
    $is_admin = isAdmin($chat_id, $username);
    
    // Check if user is admin
    if ($is_admin) {
        if ($text === '/stats') {
            $stats = getUserStats();
            $message = "📊 <b>REDLINE Bot Statistics</b>\n\n";
            $message .= "👥 <b>Total Users:</b> " . $stats['total_users'] . "\n";
            $message .= "🔥 <b>Active Users (24h):</b> " . $stats['active_users'] . "\n";
            $message .= "📈 <b>Total Interactions:</b> " . $stats['total_interactions'] . "\n\n";
            $message .= "🎯 <b>Feature Usage:</b>\n";
            foreach ($stats['feature_usage'] as $feature => $count) {
                $message .= "• " . ucfirst($feature) . ": " . $count . "\n";
            }
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/analytics') {
            // Build absolute URL to analytics.php in current directory
            $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'] ?? '';
            $basePath = rtrim(dirname($_SERVER['REQUEST_URI'] ?? '/'), '/\\');
            $analytics_url = $protocol . '://' . $host . $basePath . '/analytics.php?view=analytics';
            
            $keyboard = json_encode([
                'inline_keyboard' => [
                    [
                        ['text' => '📈 Open Analytics', 'url' => $analytics_url]
                    ]
                ]
            ]);
            
            sendMessage($chat_id, "📊 <b>Open Analytics Dashboard</b>\n\nClick the button below to view analytics.", $keyboard);
        }
        
        if ($text === '/users') {
            $stats = getUserStats();
            $message = "👥 <b>Recent Users (Last 7 Days)</b>\n\n";
            $count = 0;
            foreach ($stats['recent_users'] as $user) {
                $count++;
                $message .= $count . ". @" . ($user['username'] ?: 'Unknown') . " (ID: " . $user['chat_id'] . ")\n";
                $message .= "   Last seen: " . $user['last_seen'] . "\n";
                $message .= "   Interactions: " . $user['total_interactions'] . "\n\n";
            }
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/debug') {
            $message = "🔧 <b>Debug Information</b>\n\n";
            $message .= "🆔 <b>Your Chat ID:</b> <code>" . $chat_id . "</code>\n";
            $message .= "👤 <b>Your Username:</b> @" . $username . "\n";
            $message .= "🔑 <b>Admin Status:</b> " . ($is_admin ? "✅ Yes" : "❌ No") . "\n";
            $message .= "⚙️ <b>Config Admin Chat ID:</b> <code>" . $ADMIN_CHAT_ID . "</code>\n";
            $message .= "⚙️ <b>Config Admin Username:</b> " . $ADMIN_USERNAME . "\n";
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/commands' || $text === '/cmds') {
            $message = "📋 <b>All Available Commands</b>\n\n";
            $message .= "🔧 <b>Basic Commands:</b>\n";
            $message .= "• /start - Start the bot\n";
            $message .= "• /ping - Check bot latency\n";
            $message .= "• /commands or /cmds - View all commands\n\n";
            $message .= "👑 <b>Admin Commands:</b>\n";
            $message .= "• /stats - View bot statistics\n";
            $message .= "• /users - View recent users\n";
            $message .= "• /debug - View debug information\n";
            $message .= "• /testadmin - Test admin status\n";
            $message .= "• /makeadmin - Make yourself admin\n";
            $message .= "• /log username_or_chatid - View user interactions\n\n";
            $message .= "💰 <b>Crypto Management:</b>\n";
            $message .= "• /cryptolist - View current crypto options\n";
            $message .= "• /addcoin - Add new crypto option\n";
            $message .= "• /removecoin - Remove crypto option\n";
            $message .= "• /updatecoin - Update crypto address\n\n";
            $message .= "📝 <b>Usage Examples:</b>\n";
            $message .= "• /addcoin doge DOGECOIN address123\n";
            $message .= "• /removecoin doge\n";
            $message .= "• /updatecoin doge new_address123\n";
            $message .= "• /log @username or /log 123456789\n\n";
            $message .= "📊 <b>Analytics:</b>\n";
            $message .= "• /analytics - View analytics page\n";
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/cryptolist') {
            $message = "💰 <b>Current Crypto Options</b>\n\n";
            $count = 1;
            foreach ($PAYMENT_ADDRESSES as $key => $address) {
                $name = $CRYPTO_NAMES[$key];
                $message .= $count . ". <b>" . $name . "</b>\n";
                $message .= "   Key: " . $key . "\n";
                $message .= "   Address: " . $address . "\n\n";
                $count++;
            }
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/addcoin') {
            $message = "➕ <b>Add New Crypto</b>\n\n";
            $message .= "📝 <b>Usage:</b> /addcoin key ButtonName ADDRESS\n\n";
            $message .= "📋 <b>Example:</b>\n";
            $message .= "/addcoin doge DOGECOIN ahjdbahjbdahisdhaisbdhiabsdhab\n\n";
            $message .= "🔑 <b>Current Cryptos:</b>\n";
            foreach ($CRYPTO_NAMES as $key => $name) {
                $message .= "• " . $key . " - " . $name . "\n";
            }
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/removecoin') {
            $message = "➖ <b>Remove Crypto</b>\n\n";
            $message .= "📝 <b>Usage:</b> /removecoin key\n\n";
            $message .= "🔑 <b>Available Keys to Remove:</b>\n";
            foreach ($CRYPTO_NAMES as $key => $name) {
                $message .= "• " . $key . " - " . $name . "\n";
            }
            
            sendMessage($chat_id, $message);
        }
        
        if ($text === '/updatecoin') {
            $message = "🔄 <b>Update Crypto Address</b>\n\n";
            $message .= "📝 <b>Usage:</b> /updatecoin key new_address\n\n";
            $message .= "🔑 <b>Current Cryptos:</b>\n";
            foreach ($PAYMENT_ADDRESSES as $key => $address) {
                $name = $CRYPTO_NAMES[$key];
                $message .= "• " . $key . " - " . $name . "\n";
                $message .= "  Current: " . $address . "\n\n";
            }
            
            sendMessage($chat_id, $message);
        }
        
        if (strpos($text, '/log ') === 0) {
            $search_term = trim(substr($text, 5)); // Remove '/log ' prefix
            
            if (empty($search_term)) {
                sendMessage($chat_id, "❌ <b>Usage:</b> /log username_or_chatid\n\n<b>Examples:</b>\n• /log @username\n• /log 123456789");
                return;
            }
            
            $analytics = getAnalytics();
            $found_users = [];
            
            // Search by username or chat_id
            foreach ($analytics['users'] as $user) {
                if (strpos($user['username'], $search_term) !== false || 
                    strpos($user['chat_id'], $search_term) !== false ||
                    $user['chat_id'] == $search_term) {
                    $found_users[] = $user;
                }
            }
            
            if (empty($found_users)) {
                sendMessage($chat_id, "❌ <b>No users found</b> matching: " . $search_term);
                return;
            }
            
            $message = "📊 <b>User Interaction Log</b>\n\n";
            $message .= "🔍 <b>Search Term:</b> " . $search_term . "\n";
            $message .= "👥 <b>Found Users:</b> " . count($found_users) . "\n\n";
            
            foreach ($found_users as $user) {
                $message .= "👤 <b>Username:</b> @" . ($user['username'] ?: 'Unknown') . "\n";
                $message .= "🆔 <b>Chat ID:</b> <code>" . $user['chat_id'] . "</code>\n";
                $message .= "📅 <b>First Seen:</b> " . $user['first_seen'] . "\n";
                $message .= "⏰ <b>Last Seen:</b> " . $user['last_seen'] . "\n";
                $message .= "📈 <b>Total Interactions:</b> " . $user['total_interactions'] . "\n\n";
                
                $message .= "🎯 <b>Recent Actions:</b>\n";
                $recent_actions = array_slice($user['actions'], -10); // Last 10 actions
                foreach ($recent_actions as $action) {
                    $message .= "• " . $action['action'] . " - " . $action['timestamp'] . "\n";
                }
                $message .= "\n" . str_repeat("-", 30) . "\n\n";
            }
            
            sendMessage($chat_id, $message);
        }
    }
    
    // Ping command - report latency
    if ($text === '/ping') {
        $sentAt = isset($update['message']['date']) ? (int)$update['message']['date'] : time();
        $latencyMs = (int)round((microtime(true) - $sentAt) * 1000);
        if ($latencyMs < 0) { $latencyMs = 0; }
        $message = "🏓 <b>Pong!</b>\n\n⏱️ <b>Ping:</b> " . $latencyMs . " ms";
        sendMessage($chat_id, $message);
    }
    
    // Simple admin test command (works for anyone)
    if ($text === '/testadmin') {
        $message = "🔧 <b>Admin Test</b>\n\n";
        $message .= "🆔 <b>Your Chat ID:</b> <code>" . $chat_id . "</code>\n";
        $message .= "👤 <b>Your Username:</b> @" . $username . "\n";
        $message .= "🔑 <b>Admin Status:</b> " . ($is_admin ? "✅ Yes" : "❌ No") . "\n";
        $message .= "⚙️ <b>Config Admin Chat ID:</b> <code>" . $ADMIN_CHAT_ID . "</code>\n";
        $message .= "⚙️ <b>Config Admin Username:</b> " . $ADMIN_USERNAME . "\n\n";
        $message .= "📋 <b>If you're admin, try:</b>\n";
        $message .= "• /stats - View statistics\n";
        $message .= "• /users - View users\n";
        $message .= "• /debug - Debug info\n";
        
        sendMessage($chat_id, $message);
    }
    
    // Make you admin directly
    if ($text === '/makeadmin' && ($chat_id == '6166295496' || $username == 'redline_seller')) {
        $message = "🔑 <b>Admin Access Granted!</b>\n\n";
        $message .= "🆔 <b>Your Chat ID:</b> <code>" . $chat_id . "</code>\n";
        $message .= "👤 <b>Your Username:</b> @" . $username . "\n\n";
        $message .= "📋 <b>Admin Commands Available:</b>\n";
        $message .= "• /stats - View bot statistics\n";
        $message .= "• /users - View recent users\n";
        $message .= "• /debug - View debug information\n";
        $message .= "• /testadmin - Test admin status\n";
        $message .= "• /commands - View all commands\n\n";
        $message .= "✅ <b>You now have admin access!</b>";
        
        sendMessage($chat_id, $message);
    }
    
    // Handle crypto management commands
    if (strpos($text, '/addcoin ') === 0) {
        $parts = explode(' ', $text, 4);
        if (count($parts) >= 4) {
            $key = $parts[1];
            $name = $parts[2];
            $address = $parts[3];
            
            // Add to config arrays
            $PAYMENT_ADDRESSES[$key] = $address;
            $CRYPTO_NAMES[$key] = $name;
            
            // Update config file
            updateConfigFile($PAYMENT_ADDRESSES, $CRYPTO_NAMES);
            
            $message = "✅ <b>Crypto Added Successfully!</b>\n\n";
            $message .= "🔑 <b>Key:</b> " . $key . "\n";
            $message .= "📝 <b>Button Name:</b> " . $name . "\n";
            $message .= "💰 <b>Address:</b> " . $address . "\n\n";
            $message .= "🔄 <b>Changes applied! New crypto will appear in all payment options.</b>";
            
            sendMessage($chat_id, $message);
        } else {
            sendMessage($chat_id, "❌ <b>Invalid format!</b>\n\nUsage: /addcoin key ButtonName ADDRESS\n\nExample: /addcoin doge DOGECOIN ahjdbahjbdahisdhaisbdhiabsdhab");
        }
    }
    
    if (strpos($text, '/removecoin ') === 0) {
        $parts = explode(' ', $text, 2);
        if (count($parts) >= 2) {
            $key = $parts[1];
            
            if (isset($PAYMENT_ADDRESSES[$key])) {
                $name = $CRYPTO_NAMES[$key];
                unset($PAYMENT_ADDRESSES[$key]);
                unset($CRYPTO_NAMES[$key]);
                
                // Update config file
                updateConfigFile($PAYMENT_ADDRESSES, $CRYPTO_NAMES);
                
                $message = "✅ <b>Crypto Removed Successfully!</b>\n\n";
                $message .= "🔑 <b>Removed Key:</b> " . $key . "\n";
                $message .= "📝 <b>Removed Name:</b> " . $name . "\n\n";
                $message .= "🔄 <b>Changes applied! Crypto removed from all payment options.</b>";
                
                sendMessage($chat_id, $message);
            } else {
                sendMessage($chat_id, "❌ <b>Crypto not found!</b>\n\nKey: " . $key);
            }
        } else {
            sendMessage($chat_id, "❌ <b>Invalid format!</b>\n\nUsage: /removecoin key");
        }
    }
    
    if (strpos($text, '/updatecoin ') === 0) {
        $parts = explode(' ', $text, 3);
        if (count($parts) >= 3) {
            $key = $parts[1];
            $new_address = $parts[2];
            
            if (isset($PAYMENT_ADDRESSES[$key])) {
                $old_address = $PAYMENT_ADDRESSES[$key];
                $PAYMENT_ADDRESSES[$key] = $new_address;
                
                // Update config file
                updateConfigFile($PAYMENT_ADDRESSES, $CRYPTO_NAMES);
                
                $message = "✅ <b>Crypto Address Updated!</b>\n\n";
                $message .= "🔑 <b>Key:</b> " . $key . "\n";
                $message .= "📝 <b>Name:</b> " . $CRYPTO_NAMES[$key] . "\n";
                $message .= "💰 <b>Old Address:</b> " . $old_address . "\n";
                $message .= "💰 <b>New Address:</b> " . $new_address . "\n\n";
                $message .= "🔄 <b>Changes applied! New address will be used for all payments.</b>";
                
                sendMessage($chat_id, $message);
            } else {
                sendMessage($chat_id, "❌ <b>Crypto not found!</b>\n\nKey: " . $key);
            }
        } else {
            sendMessage($chat_id, "❌ <b>Invalid format!</b>\n\nUsage: /updatecoin key new_address");
        }
    }
}

// Handle button clicks
if (isset($update['callback_query'])) {
    $chat_id = $update['callback_query']['message']['chat']['id'];
    $data = $update['callback_query']['data'];
    $callback_id = $update['callback_query']['id'];
    $username = $update['callback_query']['from']['username'] ?? 'Unknown';
    
    // Track user interaction
    trackUser($chat_id, $username, $data);
    
    // Answer callback
    $url = "https://api.telegram.org/bot$BOT_TOKEN/answerCallbackQuery";
    $data_answer = ['callback_query_id' => $callback_id];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_answer));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
    
    if ($data === 'start') {
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '🔥 PRIVATE REDLINE LOGS 🔥', 'callback_data' => 'logs']],
                [['text' => '💉 REDLINE STEALER TOOL 💉', 'callback_data' => 'stealer']]
            ]
        ]);
        
        $message = $MESSAGES['choose_products'];
        
        // Send new message for product selection (this will be the one we edit later)
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
        $data_msg = [
            'chat_id' => $chat_id,
            'text' => $message,
            'parse_mode' => 'HTML',
            'reply_markup' => $keyboard
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_msg));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);
    }
    
    if ($data === 'logs') {
        $message = "🔥 <b>The REDLINE Advantage: 14 Million Logs and Growing</b> 🔥\n\n⚡️<b><u>Daily Influx: Injecting 10,000 - 15,000 untouched new logs every day into the cloud.</u></b>⚡️\n\n<i>Access Instant Value:</i>\n<i>🎁Big Tech & Travel: Airbnb, Booking, Microsoft, and Brocard access. 🏢</i>\n<i>🎁Crypto & Gaming: Wallets, Cryptocurrency, Apple, and Game credentials. 🎮</i>\n<i>🎁Monetary Access: Credit Cards, Bank Accounts, PayPal, Steam, and Epic Games details. 💸</i>\n<i>🎁Streaming Services: Netflix, Amazon, and Spotify accounts. 🍿</i>\n<i>🎁Quality Assured: Every single log is new and contains live, working cookies. 🍪</i>\n\n🌍<b>Targeted Geos: 🇺🇸 USA, 🇬🇧 UK, 🇩🇪 DE, 🇪🇺 EU, 🇦🇺 AU, 🇨🇦 CA, 🇧🇩 BD, 🇮🇳 IN, 🇪🇸 ES, 🇮🇹 IT, 🇫🇷 FR, 🇳🇱 NL, 🇸🇪 SE, 🇨🇭 CH, 🇳🇴 NO, 🇩🇰 DK, 🇫🇮 FI, 🇧🇪 BE, 🇵🇱 PL, 🇨🇿 CZ, 🇵🇹 PT, 🇬🇷 GR, 🇭🇺 HU, 🇷🇴 RO, 🇧🇬 BG, 🇷🇸 RS, 🇹🇷 TR, 🇮🇱 IL, 🇯🇵 JP, 🇸🇬 SG, 🇦🇪 AE, 🇸🇦 SA, 🇶🇦 QA, 🇰🇷 KR, 🇹🇭 TH, 🇻🇳 VN, 🇮🇩 ID, 🇲🇾 MY, 🇵🇭 PH, 🇳🇿 NZ, 🇲🇽 MX, 🇧🇷 BR, 🇦🇷 AR, 🇨🇱 CL, 🇿🇦 ZA, 🇳🇬 NG, 🇰🇪 KE, 🇪🇬 EG and MIX.</b> 🗺️\n\n🔥 Enjoy full access to our <b>Advanced Log Checker</b> 💻 with your subscription!\n⚙️ Filter ⚡️ Search 🔍 and find exactly what matters most! 🌟\n\nSelect a tariff or category from the list below 👇";
        
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '🕒 1 Week - $80', 'callback_data' => 'week']],
                [['text' => '📅 1 Month - $250', 'callback_data' => 'month']],
                [['text' => '⏰ 3 Month - $550', 'callback_data' => 'quarter']],
                [['text' => '🔙 Back to Main Menu', 'callback_data' => 'start']]
            ]
        ]);
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'stealer') {
        $message = "<b>REDLINE Log Management & Exploitation Platform</b> 💉\n\nThis isn't just software; it's a command center designed for maximum data leverage and untraceable execution.\n\n🖥️ <b>Deep Dive Dashboard: Instant Intelligence</b> 🧠\nLog Fingerprinting: View unique logs identified by ID, IP, OS, and Country 🌍.\nAdd Comment Tags 🏷️ for proprietary organization.\nData Vault Access: Instantly view every stolen asset: Browser Logins, Credit Cards 💳, Cookies 🍪, FTP/IM Client Data 📧, and File Grabber Harvests 🗃️.\nGlobal Metrics: Real-time statistics on total assets and the Top 10 Geo-Targets and OS distributions 📊.\n\n🛠️ <b>Execution & Deployment: Beyond Static Data</b> 💣\nDynamic Task Engine: Deploy payloads with unparalleled flexibility: RunPE: Execute advanced 32-bit payload injection 💉 into a specified host process. Download & Execute: Simple file delivery and launch ▶️. OpenLink: Force URL execution 🔗 for traffic redirection or phishing.\n\n🛡️ <b>Stealth & Customization: Build Your Phantom</b> 👤\nIntegrated Builder: Generate builds with hyper-specific parameters.\nEvasion Toolkit: Clone Certificates for authenticity camouflage 🎭. Artificially inflate file weight ⚖️ to bypass initial filters.\nOperational Control: Blacklist countries 🚫, toggle data collection (Browser/FTP/Grabber), and enable Anti-Duplicate filtering.\n\n🤖 <b>The PRO Advantage: Unrestricted Power</b> 💥\nThe PRO Plan unlocks tools for unlimited Crypto 🪙 harvesting, continuous Dyncheck Detection Scans 🔬, DOC Gluing 🧱, and Unlimited Loader Links. 💰\n\n<b>Acquisition Protocols: Secure Your License Today!</b> 🔑\nFree, Lifetime Updates are included to ensure your platform remains ahead of the curve.\n\n<b>🕒 1 Month Plan: $150 USD</b>\nIncludes 1-Month Stealer License\nBONUS: + 1 Month Cryptor Gift! 👑\n\n<b>⏰ 3 Month Plan: $350 USD</b>\nIncludes 3-Month Stealer License\nBONUS: + 2 Month Cryptor Gift! 👑\n\n<b>👑 Lifetime Plan: $900 USD</b>\nIncludes Lifetime Stealer License\nBONUS: + 9 Month Cryptor & Scanner! Also grants 6 months of access to the PRO Bot Tools.\n\n<b>Don't just manage logs—dominate the data flow. 👇</b>";
        
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '🕒 1 Month Plan - $150', 'callback_data' => 'stealer_1month']],
                [['text' => '⏰ 3 Month Plan - $350', 'callback_data' => 'stealer_3month']],
                [['text' => '👑 Lifetime Plan - $900', 'callback_data' => 'stealer_lifetime']],
                [['text' => '🔙 Back to Main Menu', 'callback_data' => 'start']]
            ]
        ]);
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    // Payment options
    if ($data === 'week') {
        $message = "💳 Please choose your payment method for <b>1 Week - $80 USD</b>:";
        $keyboard = generatePaymentButtons(80, 'logs');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'month') {
        $message = "💳 Please choose your payment method for <b>1 Month - $250 USD</b>:";
        $keyboard = generatePaymentButtons(250, 'logs');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'quarter') {
        $message = "💳 Please choose your payment method for <b>3 Month - $550 USD</b>:";
        $keyboard = generatePaymentButtons(550, 'logs');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    // Stealer plans
    if ($data === 'stealer_1month') {
        $message = "💳 Please choose your payment method for <b>1 Month Plan - $150 USD</b>:";
        $keyboard = generatePaymentButtons(150, 'stealer');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'stealer_3month') {
        $message = "💳 Please choose your payment method for <b>3 Month Plan - $350 USD</b>:";
        $keyboard = generatePaymentButtons(350, 'stealer');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'stealer_lifetime') {
        $message = "💳 Please choose your payment method for <b>Lifetime Plan - $900 USD</b>:";
        $keyboard = generatePaymentButtons(900, 'stealer');
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    // Payment details
    if (strpos($data, 'pay_') === 0) {
        $parts = explode('_', $data);
        $method = $parts[1];
        $amount = $parts[2];
        
        $addresses = $PAYMENT_ADDRESSES;
        $method_names = $CRYPTO_NAMES;
        
        // Check if method exists in arrays
        if (!isset($method_names[$method])) {
            $message = "❌ <b>Error:</b> Payment method not found: " . $method . "\n\n";
            $message .= "🔑 <b>Available methods:</b>\n";
            foreach ($method_names as $key => $name) {
                $message .= "• " . $key . " - " . $name . "\n";
            }
        } elseif (!isset($addresses[$method])) {
            $message = "❌ <b>Error:</b> Payment address not found for: " . $method;
        } else {
            $message = "💳 <b>Payment Method:</b> " . $method_names[$method] . "\n💰 <b>Amount to pay:</b> $" . $amount . "\n\n\n💸 <b>Payment in " . $method_names[$method] . " to wallet:</b>\n\n<code>" . $addresses[$method] . "</code>\n\n<i>Click the address above to copy it</i>\n\n📝 <b>Instructions:</b>\n• Make the payment to the address above\n• Click 'I have Paid' button\n\n⚠️ <b>Without screenshot, payment will not be processed!</b>";
        }
        
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '✅ I have Paid', 'callback_data' => 'paid']],
                [['text' => '❌ Cancel Payment', 'callback_data' => 'cancel']]
            ]
        ]);
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    
    if ($data === 'paid') {
        $message = "📸 <b>Payment Screenshot Required</b>\n\n";
        $message .= "✅ Thank you for your payment!\n";
        $message .= "📷 <b>Please send a screenshot of your payment</b>\n";
        $message .= "⏳ Your payment will be processed after screenshot verification";
        
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '🔙 Back to Main Menu', 'callback_data' => 'start']]
            ]
        ]);
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
    
    if ($data === 'cancel') {
        $message = $MESSAGES['payment_cancelled'];
        
        $keyboard = json_encode([
            'inline_keyboard' => [
                [['text' => '🔙 Back to Main Menu', 'callback_data' => 'start']]
            ]
        ]);
        
        editMessage($chat_id, $update['callback_query']['message']['message_id'], $message, $keyboard);
    }
}

// Function to generate dynamic payment buttons
function generatePaymentButtons($amount, $back_callback = 'logs') {
    global $CRYPTO_NAMES;
    
    $buttons = [];
    foreach ($CRYPTO_NAMES as $key => $name) {
        $buttons[] = [['text' => $name, 'callback_data' => 'pay_' . $key . '_' . $amount]];
    }
    $buttons[] = [['text' => '🔙 Back', 'callback_data' => $back_callback]];
    
    return json_encode(['inline_keyboard' => $buttons]);
}

// Helper function to send messages
function sendMessage($chat_id, $message, $keyboard = null) {
    global $BOT_TOKEN;
    
    $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    if ($keyboard) {
        $data['reply_markup'] = $keyboard;
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_exec($ch);
    curl_close($ch);
}

// Function to update config file
function updateConfigFile($addresses, $names) {
    $config_content = "<?php\n";
    $config_content .= "// config.php\n";
    $config_content .= "\$BOT_TOKEN = '8364465895:AAELfHYndDjcIpx7FL_waRNpE0Q7G8y0Zt0';\n\n";
    $config_content .= "// Payment Addresses\n";
    $config_content .= "\$PAYMENT_ADDRESSES = [\n";
    foreach ($addresses as $key => $address) {
        $config_content .= "    '$key' => '$address',\n";
    }
    $config_content .= "];\n\n";
    $config_content .= "// Admin Configuration\n";
    $config_content .= "\$ADMIN_CHAT_ID = '6166295496';\n";
    $config_content .= "\$ADMIN_USERNAME = 'redline_seller';\n\n";
    $config_content .= "// Crypto Method Names\n";
    $config_content .= "\$CRYPTO_NAMES = [\n";
    foreach ($names as $key => $name) {
        $config_content .= "    '$key' => '$name',\n";
    }
    $config_content .= "];\n\n";
    $config_content .= "// Pricing\n";
    $config_content .= "\$PRICING = [\n";
    $config_content .= "    'week' => 80,\n";
    $config_content .= "    'month' => 250,\n";
    $config_content .= "    'quarter' => 550,\n";
    $config_content .= "    'stealer_1month' => 150,\n";
    $config_content .= "    'stealer_3month' => 350,\n";
    $config_content .= "    'stealer_lifetime' => 900\n";
    $config_content .= "];\n\n";
    $config_content .= "\$MESSAGES = [\n";
    $config_content .= "    'welcome' => \"Welcome to REDLINE !\\n\\nClick the button below to begin\",\n";
    $config_content .= "    'choose_products' => \"Choose Products 👇\",\n";
    $config_content .= "    'redline_logs' => \"🔥 <b>The REDLINE Advantage: 14 Million Logs and Growing</b> 🔥\\n\\n⚡️<b><u>Daily Influx: Injecting 10,000 - 15,000 untouched new logs every day into the cloud.</u></b>⚡️\\n\\n<i>Access Instant Value:</i>\\n<i>🎁Big Tech & Travel: Airbnb, Booking, Microsoft, and Brocard access. 🏢</i>\\n<i>🎁Crypto & Gaming: Wallets, Cryptocurrency, Apple, and Game credentials. 🎮</i>\\n<i>🎁Monetary Access: Credit Cards, Bank Accounts, PayPal, Steam, and Epic Games details. 💸</i>\\n<i>🎁Streaming Services: Netflix, Amazon, and Spotify accounts. 🍿</i>\\n<i>🎁Quality Assured: Every single log is new and contains live, working cookies. 🍪</i>\\n\\n🌍<b>Targeted Geos: 🇺🇸 USA, 🇩🇪 DE, 🇬🇧 GB, 🇪🇺 EU, 🇦🇺 AU, 🇨🇦 CA, 🇬🇧 UK, 🇧🇩 BD, 🇮🇳 IN, 🇪🇸 ES, and MIX.</b> 🗺️\\n\\n🔥 Enjoy full access to our <b>Advanced Log Checker</b> 💻 with your subscription!\\n⚙️ Filter ⚡️ Search 🔍 and find exactly what matters most! 🌟\\n\\nSelect a tariff or category from the list below 👇\",\n";
    $config_content .= "    'redline_stealer' => \"<b>REDLINE Log Management & Exploitation Platform</b> 💉\\n\\nThis isn't just software; it's a command center designed for maximum data leverage and untraceable execution.\\n\\n🖥️ <b>Deep Dive Dashboard: Instant Intelligence</b> 🧠\\nLog Fingerprinting: View unique logs identified by ID, IP, OS, and Country 🌍.\\nAdd Comment Tags 🏷️ for proprietary organization.\\nData Vault Access: Instantly view every stolen asset: Browser Logins, Credit Cards 💳, Cookies 🍪, FTP/IM Client Data 📧, and File Grabber Harvests 🗃️.\\nGlobal Metrics: Real-time statistics on total assets and the Top 10 Geo-Targets and OS distributions 📊.\\n\\n🛠️ <b>Execution & Deployment: Beyond Static Data</b> 💣\\nDynamic Task Engine: Deploy payloads with unparalleled flexibility: RunPE: Execute advanced 32-bit payload injection 💉 into a specified host process. Download & Execute: Simple file delivery and launch ▶️. OpenLink: Force URL execution 🔗 for traffic redirection or phishing.\\n\\n🛡️ <b>Stealth & Customization: Build Your Phantom</b> 👤\\nIntegrated Builder: Generate builds with hyper-specific parameters.\\nEvasion Toolkit: Clone Certificates for authenticity camouflage 🎭. Artificially inflate file weight ⚖️ to bypass initial filters.\\nOperational Control: Blacklist countries 🚫, toggle data collection (Browser/FTP/Grabber), and enable Anti-Duplicate filtering.\\n\\n🤖 <b>The PRO Advantage: Unrestricted Power</b> 💥\\nThe PRO Plan unlocks tools for unlimited Crypto 🪙 harvesting, continuous Dyncheck Detection Scans 🔬, DOC Gluing 🧱, and Unlimited Loader Links. 💰\\n\\n<b>Acquisition Protocols: Secure Your License Today!</b> 🔑\\nFree, Lifetime Updates are included to ensure your platform remains ahead of the curve.\\n\\n<b>🕒 2 Months Plan: $300 USD</b>\\nIncludes 2-Month Stealer License\\nBONUS: + 1 Month Cryptor Gift! 👑\\n\\n<b>👑 PRO (Lifetime Access): $700 USD</b>\\nIncludes Lifetime Stealer License\\nBONUS: + 9 Month Cryptor & Scanner! Also grants 6 months of access to the PRO Bot Tools.\\n\\n<b>Don't just manage logs—dominate the data flow. 👇</b>\",\n";
    $config_content .= "    'payment_processing' => \"🎉 <b>Payment Processing</b> 🎉\\n\\n⏳ <b>Processing Status:</b> Your payment is being verified\\n\\n🔍 <b>Verification Process:</b>\\n• Blockchain confirmation in progress\\n• Payment validation underway\\n• Subscription activation pending\\n\\n📧 <b>Next Steps:</b>\\n• You will receive a confirmation notification\\n• Your subscription will be activated shortly\\n• Access credentials will be provided via DM\\n\\n⏰ <b>Estimated Time:</b> 5-15 minutes\\n\\nThank you for choosing REDLINE! 🚀\",\n";
    $config_content .= "    'payment_cancelled' => \"❌ <b>Payment Cancelled</b>\\n\\nYour payment has been cancelled. You can try again anytime.\\n\\nThank you for your interest in REDLINE! 🚀\"\n";
    $config_content .= "];\n";
    $config_content .= "?>";
    
    file_put_contents('config.php', $config_content);
}

// Admin helper functions
function isAdmin($chat_id, $username) {
    global $ADMIN_CHAT_ID, $ADMIN_USERNAME;
    
    // Only allow specific admin (redline_seller)
    if ($chat_id == $ADMIN_CHAT_ID || $username == $ADMIN_USERNAME) {
        return true;
    }
    
    return false;
}

function sendAdminNotification($chat_id, $username, $type) {
    global $ADMIN_CHAT_ID, $BOT_TOKEN;
    
    // Skip if admin chat ID not set
    if (empty($ADMIN_CHAT_ID) || $ADMIN_CHAT_ID === 'YOUR_ADMIN_CHAT_ID') {
        return;
    }
    
    $message = "";
    
    if ($type === 'new_user') {
        $message = "🆕 <b>New User Started Bot</b>\n\n";
        $message .= "👤 <b>Username:</b> @" . $username . "\n";
        $message .= "🆔 <b>Chat ID:</b> <code>" . $chat_id . "</code>\n";
        $message .= "⏰ <b>Time:</b> " . date('Y-m-d H:i:s') . "\n";
    } elseif ($type === 'screenshot_received') {
        $message = "📸 <b>Payment Screenshot Received</b>\n\n";
        $message .= "👤 <b>Username:</b> @" . $username . "\n";
        $message .= "🆔 <b>Chat ID:</b> <code>" . $chat_id . "</code>\n";
        $message .= "⏰ <b>Time:</b> " . date('Y-m-d H:i:s') . "\n";
        $message .= "📷 <b>User sent payment screenshot</b>\n";
        $message .= "✅ <b>Ready for verification</b>\n";
        $message .= "🔍 <b>Check chat history for screenshot</b>\n";
    }
    
    if ($message) {
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
        $data = [
            'chat_id' => $ADMIN_CHAT_ID,
            'text' => $message,
            'parse_mode' => 'HTML'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_exec($ch);
        curl_close($ch);
    }
}

// Function to edit messages instead of sending new ones
function editMessage($chat_id, $message_id, $text, $keyboard = null) {
    global $BOT_TOKEN;
    
    $url = "https://api.telegram.org/bot$BOT_TOKEN/editMessageText";
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($keyboard) {
        $data['reply_markup'] = $keyboard;
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_exec($ch);
    curl_close($ch);
}

// Function to forward screenshot to admin
function forwardScreenshotToAdmin($message, $chat_id, $username) {
    global $BOT_TOKEN, $ADMIN_CHAT_ID;
    
    // Skip if admin chat ID not set
    if (empty($ADMIN_CHAT_ID) || $ADMIN_CHAT_ID === 'YOUR_ADMIN_CHAT_ID') {
        return;
    }
    
    // Send header message to admin
    $header_message = "📸 <b>Payment Screenshot from User</b>\n\n";
    $header_message .= "👤 <b>Username:</b> @" . $username . "\n";
    $header_message .= "🆔 <b>Chat ID:</b> <code>" . $chat_id . "</code>\n";
    $header_message .= "⏰ <b>Time:</b> " . date('Y-m-d H:i:s') . "\n";
    $header_message .= "📷 <b>Screenshot below:</b>";
    
    $url = "https://api.telegram.org/bot$BOT_TOKEN/sendMessage";
    $data = [
        'chat_id' => $ADMIN_CHAT_ID,
        'text' => $header_message,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_exec($ch);
    curl_close($ch);
    
    // Forward the screenshot to admin
    if (isset($message['photo'])) {
        // Handle photo
        $photo = end($message['photo']); // Get highest resolution
        $file_id = $photo['file_id'];
        
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendPhoto";
        $data = [
            'chat_id' => $ADMIN_CHAT_ID,
            'photo' => $file_id,
            'caption' => "📸 Payment Screenshot from @" . $username . " (ID: " . $chat_id . ")"
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_exec($ch);
        curl_close($ch);
        
    } elseif (isset($message['document'])) {
        // Handle document
        $file_id = $message['document']['file_id'];
        
        $url = "https://api.telegram.org/bot$BOT_TOKEN/sendDocument";
        $data = [
            'chat_id' => $ADMIN_CHAT_ID,
            'document' => $file_id,
            'caption' => "📸 Payment Screenshot from @" . $username . " (ID: " . $chat_id . ")"
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_exec($ch);
        curl_close($ch);
    }
}
?>
