<?php
// REDLINE Bot Setup Script - Independent Version
require_once 'config.php';

// Get current domain
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$domain = $protocol . '://' . $_SERVER['HTTP_HOST'];
$webhook_url = $domain . '/basic_bot.php';

// Handle webhook actions
if (isset($_GET['action'])) {
    if ($_GET['action'] === 'enable') {
        $result = setWebhook($webhook_url);
        if ($result['ok']) {
            echo "<div style='background: #d4edda; color: #155724; padding: 10px; border: 1px solid #c3e6cb; border-radius: 5px; margin: 10px 0;'>✅ Webhook enabled successfully!</div>";
        } else {
            echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border: 1px solid #f5c6cb; border-radius: 5px; margin: 10px 0;'>❌ Failed to enable webhook: " . ($result['description'] ?? 'Unknown error') . "</div>";
        }
    } elseif ($_GET['action'] === 'custom') {
        if (isset($_POST['custom_url']) && !empty($_POST['custom_url'])) {
            $custom_url = $_POST['custom_url'];
            $result = setWebhook($custom_url);
            if ($result['ok']) {
                echo "<div style='background: #d4edda; color: #155724; padding: 10px; border: 1px solid #c3e6cb; border-radius: 5px; margin: 10px 0;'>✅ Custom webhook set successfully!</div>";
                echo "<div style='background: #d1ecf1; color: #0c5460; padding: 10px; border: 1px solid #bee5eb; border-radius: 5px; margin: 10px 0;'><strong>Custom URL:</strong> $custom_url</div>";
            } else {
                echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border: 1px solid #f5c6cb; border-radius: 5px; margin: 10px 0;'>❌ Failed to set custom webhook: " . ($result['description'] ?? 'Unknown error') . "</div>";
            }
        } else {
            echo "<div style='background: #fff3cd; color: #856404; padding: 10px; border: 1px solid #ffeaa7; border-radius: 5px; margin: 10px 0;'>⚠️ Please enter a custom URL</div>";
        }
    } elseif ($_GET['action'] === 'disable') {
        $result = setWebhook('');
        if ($result['ok']) {
            echo "<div style='background: #d4edda; color: #155724; padding: 10px; border: 1px solid #c3e6cb; border-radius: 5px; margin: 10px 0;'>✅ Webhook disabled successfully!</div>";
        } else {
            echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border: 1px solid #f5c6cb; border-radius: 5px; margin: 10px 0;'>❌ Failed to disable webhook: " . ($result['description'] ?? 'Unknown error') . "</div>";
        }
    } elseif ($_GET['action'] === 'status') {
        $webhook_info = getWebhookInfo();
        if ($webhook_info['ok']) {
            $webhook = $webhook_info['result'];
            if ($webhook['url']) {
                echo "<div style='background: #d1ecf1; color: #0c5460; padding: 10px; border: 1px solid #bee5eb; border-radius: 5px; margin: 10px 0;'>";
                echo "<strong>Webhook Status:</strong> Active<br>";
                echo "<strong>URL:</strong> " . $webhook['url'] . "<br>";
                echo "<strong>Pending Updates:</strong> " . $webhook['pending_update_count'] . "<br>";
                echo "<strong>Last Error Date:</strong> " . ($webhook['last_error_date'] ? date('Y-m-d H:i:s', $webhook['last_error_date']) : 'None') . "<br>";
                echo "<strong>Last Error Message:</strong> " . ($webhook['last_error_message'] ?? 'None');
                echo "</div>";
            } else {
                echo "<div style='background: #fff3cd; color: #856404; padding: 10px; border: 1px solid #ffeaa7; border-radius: 5px; margin: 10px 0;'>⚠️ Webhook is not set</div>";
            }
        } else {
            echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border: 1px solid #f5c6cb; border-radius: 5px; margin: 10px 0;'>❌ Failed to get webhook info</div>";
        }
    }
}

echo "<h1>REDLINE Bot Setup</h1>";
echo "<p><strong>Bot Token:</strong> $BOT_TOKEN</p>";
echo "<p><strong>Webhook URL:</strong> $webhook_url</p>";

// Webhook control buttons
echo "<h2>Webhook Control</h2>";
echo "<div style='margin: 20px 0;'>";
echo "<a href='?action=enable' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>✅ Enable Webhook</a>";
echo "<a href='?action=disable' style='background: #dc3545; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>❌ Disable Webhook</a>";
echo "<a href='?action=status' style='background: #17a2b8; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>📊 Check Status</a>";
echo "<a href='analytics.php?view=analytics' style='background: #6f42c1; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>📈 View Analytics</a>";
echo "</div>";

// Custom URL form
echo "<h2>Custom Webhook URL</h2>";
echo "<form method='post' action='?action=custom' style='background: #f8f9fa; padding: 20px; border-radius: 5px; margin: 20px 0;'>";
echo "<div style='margin-bottom: 15px;'>";
echo "<label for='custom_url' style='display: block; margin-bottom: 5px; font-weight: bold;'>Custom Webhook URL:</label>";
echo "<input type='url' id='custom_url' name='custom_url' placeholder='https://yourdomain.com/folder/bot.php' style='width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 3px; font-size: 14px;' required>";
echo "<small style='color: #666;'>Enter the full URL where your bot file is located</small>";
echo "</div>";
echo "<button type='submit' style='background: #6f42c1; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;'>🔗 Set Custom Webhook</button>";
echo "</form>";

// Examples
echo "<h3>Examples:</h3>";
echo "<ul style='background: #e9ecef; padding: 15px; border-radius: 5px;'>";
echo "<li><strong>Root folder:</strong> <code>https://redlinesupport.online/basic_bot.php</code></li>";
echo "<li><strong>Subfolder:</strong> <code>https://redlinesupport.online/bots/basic_bot.php</code></li>";
echo "<li><strong>Custom folder:</strong> <code>https://redlinesupport.online/telegram/basic_bot.php</code></li>";
echo "<li><strong>Different domain:</strong> <code>https://yourdomain.com/bot.php</code></li>";
echo "</ul>";

// Set webhook
function setWebhook($url) {
    global $BOT_TOKEN;
    $api_url = "https://api.telegram.org/bot$BOT_TOKEN/setWebhook";
    
    $data = ['url' => $url];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// Check if REDLINE.png exists
if (file_exists('REDLINE.png')) {
    echo "<p style='color: green;'>✅ REDLINE.png found</p>";
} else {
    echo "<p style='color: red;'>❌ REDLINE.png not found - Please upload REDLINE.png to the same folder</p>";
}

// Check if redline_bot.php exists
if (file_exists('redline_bot.php')) {
    echo "<p style='color: green;'>✅ redline_bot.php found</p>";
} else {
    echo "<p style='color: red;'>❌ redline_bot.php not found</p>";
}

echo "<h2>Setting Webhook...</h2>";

$result = setWebhook($webhook_url);

if ($result['ok']) {
    echo "<p style='color: green;'>✅ Webhook set successfully!</p>";
    echo "<p><strong>Result:</strong> " . $result['description'] . "</p>";
} else {
    echo "<p style='color: red;'>❌ Failed to set webhook</p>";
    echo "<p><strong>Error:</strong> " . ($result['description'] ?? 'Unknown error') . "</p>";
}

echo "<h2>Bot Status</h2>";

// Get webhook info
function getWebhookInfo() {
    global $BOT_TOKEN;
    $api_url = "https://api.telegram.org/bot$BOT_TOKEN/getWebhookInfo";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// Get bot info
function getBotInfo() {
    global $BOT_TOKEN;
    $api_url = "https://api.telegram.org/bot$BOT_TOKEN/getMe";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

$bot_info = getBotInfo();

if ($bot_info['ok']) {
    $bot = $bot_info['result'];
    echo "<p><strong>Bot Name:</strong> " . $bot['first_name'] . "</p>";
    echo "<p><strong>Bot Username:</strong> @" . $bot['username'] . "</p>";
    echo "<p><strong>Bot ID:</strong> " . $bot['id'] . "</p>";
} else {
    echo "<p style='color: red;'>❌ Failed to get bot info</p>";
}

echo "<h2>Test Your Bot</h2>";
echo "<p>1. Open Telegram and search for your bot</p>";
echo "<p>2. Send /start command</p>";
echo "<p>3. Click the 'Start' button</p>";
echo "<p>4. Test all buttons and navigation</p>";

echo "<h2>Files Required</h2>";
echo "<ul>";
echo "<li>redline_bot.php (main bot file)</li>";
echo "<li>REDLINE.png (bot image)</li>";
echo "<li>setup.php (this file)</li>";
echo "</ul>";

echo "<h2>Manual Webhook Setup</h2>";
echo "<p>If automatic setup fails, manually set webhook by visiting:</p>";
echo "<p><a href='https://api.telegram.org/bot$BOT_TOKEN/setWebhook?url=$webhook_url' target='_blank'>https://api.telegram.org/bot$BOT_TOKEN/setWebhook?url=$webhook_url</a></p>";
?>